<?php $this->load->view('settings/partials/header') ?>
<div class="window-content">
    <div class="page-loader" style="display: none;"></div>
    <div class="pane-group">
        <?php $this->load->view('settings/partials/sidebar') ?>
        <div class="pane content-configuration">
            <div class="caption">
                <div class="tab-group secondary-navigation">
                    <div class="tab-item" onclick="zamanEposNavigator('', '<?php echo site_url('customer') ?>', '')"><span class="icon icon-user-add">&nbsp;<?php echo $this->lang->line('customers') ?></span></div>
                </div>
            </div>
            <?php echo form_open('customer/save', array('id' => 'customerForm')); ?>
            <?php if (isset($thisCustomer) && !empty($thisCustomer)): ?>
                <input type="hidden" name="id" value="<?php echo $thisCustomer['id'] ?>"/>
                <input type="hidden" id="updateCustomer" value="yes">
                <input type="hidden" id="oldCustomerPhone" value="<?php echo $thisCustomer['phone'] ?>">
                <input type="hidden" id="oldCustomerEmail" value="<?php echo $thisCustomer['email'] ?>">
            <?php endif; ?>
            <div class="employee-add-block">
                <div class="one-fifth">
                    <div class="block-inner">
                        <div class="form-group">
                            <label><?php echo $this->lang->line('name') ?></label>
                            <input name="name" type="text" value="<?php echo!empty($thisCustomer) ? $thisCustomer['name'] : '' ?>" class="form-control" placeholder="<?php echo $this->lang->line('name') ?>">
                        </div>
                    </div>
                </div>
                <div class="one-fifth">
                    <div class="block-inner">
                        <div class="form-group">
                            <label><?php echo $this->lang->line('gender') ?></label>
                            <select name="gender" class="form-control">
                                <option value=""><?php echo $this->lang->line('select') ?></option>
                                <option value="Male" <?php !empty($thisCustomer) && $thisCustomer['gender'] === 'Male' ? print 'selected="selected"' : '' ?>><?php echo $this->lang->line('male') ?></option>
                                <option value="Female" <?php !empty($thisCustomer) && $thisCustomer['gender'] === 'Female' ? print 'selected="selected"' : '' ?>><?php echo $this->lang->line('female') ?></option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="one-fifth">
                    <div class="block-inner">
                        <div class="form-group">
                            <label><?php echo $this->lang->line('email_address') ?></label>
                            <input name="email" id="customerEmail" value="<?php echo!empty($thisCustomer) ? $thisCustomer['email'] : '' ?>" type="text" class="form-control" placeholder="<?php echo $this->lang->line('email_address') ?>">
                        </div>
                    </div>
                </div>
                <div class="one-fifth">
                    <div class="block-inner">
                        <div class="form-group">
                            <label><?php echo $this->lang->line('phone') ?></label>
                            <input name="phone" id="customerPhone" value="<?php echo!empty($thisCustomer) ? $thisCustomer['phone'] : '' ?>" type="text" class="form-control" placeholder="<?php echo $this->lang->line('phone') ?>">
                        </div>
                    </div>
                </div>
                <div class="clearfix"></div>
                <div class="one-fifth">
                    <div class="block-inner">
                        <div class="form-group">
                            <label><?php echo $this->lang->line('username') ?></label>
                            <input name="username" type="text" value="<?php echo!empty($thisCustomer) ? $thisCustomer['username'] : '' ?>" class="form-control" placeholder="<?php echo $this->lang->line('username') ?>">
                        </div>
                    </div>
                </div>
                <div class="one-fifth">
                    <div class="block-inner">
                        <div class="form-group">
                            <label><?php echo $this->lang->line('password') ?></label>
                            <input name="password" type="password" id="registerFormPassword" value="" class="form-control" placeholder="<?php echo $this->lang->line('password') ?>">
                        </div>
                    </div>
                </div>
                <div class="one-fifth">
                    <div class="block-inner">
                        <div class="form-group">
                            <label><?php echo $this->lang->line('confirm_password') ?></label>
                            <input name="confirmPassword" type="password" class="form-control" placeholder="<?php echo $this->lang->line('confirm_password') ?>">
                        </div>
                    </div>
                </div>
                <div class="one-fifth">
                    <div class="block-inner">
                        <div class="form-group">
                            <label><?php echo $this->lang->line('country') ?></label>
                            <input name="country" value="<?php echo!empty($thisCustomer) ? $thisCustomer['country'] : $branch['address_country'] ?>" type="text" class="form-control" placeholder="<?php echo $this->lang->line('country') ?>" readonly="readonly">
                        </div>
                    </div>
                </div>
                <div class="clearfix"></div>
                <div class="one-fifth">
                    <div class="block-inner">
                        <div class="form-group">
                            <label><?php echo $this->lang->line('region') ?></label>
                            <input name="region" value="<?php isset($thisEmployee) ? print $thisEmployee['region'] : print $branch['address_region'] ?>" type="text" class="form-control" placeholder="<?php echo $this->lang->line('region') ?>" readonly="readonly">
                        </div>
                    </div>
                </div>
                <div class="one-fifth">
                    <div class="block-inner">
                        <div class="form-group">
                            <label><?php echo $this->lang->line('city') ?></label>
                            <?php if (!empty($thisCustomer)): ?>
                                <input type="text" name="city" value="<?php echo!empty($thisCustomer) ? $thisCustomer['email'] : '' ?>" class="form-control" placeholder="<?php echo $this->lang->line('city') ?>" <?php !empty($loaded_plan) && trim($loaded_plan['city']) != null ? print'disabled="disabled"' : 'readonly="readonly"' ?>>
                            <?php else: ?>
                                <select name="city" class="form-control" onchange="getDeliveryCityAreas(this.value)">
                                    <?php foreach ($branchAdjacentCities as $acity): ?>
                                        <option value="<?php echo $acity->title ?>"><?php echo $acity->title ?></option>
                                    <?php endforeach; ?>
                                </select>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="one-fifth">
                    <div class="block-inner">
                        <div class="form-group">
                            <label><?php echo $this->lang->line('area') ?></label>
                            <?php if (!empty($thisCustomer)): ?>
                                <input type="text" name="area" value="<?php print $thisCustomer ['area'] ?>" class="form-control" placeholder="<?php echo $this->lang->line('area') ?>" <?php !empty($loaded_plan) && trim($loaded_plan['area']) != null ? print'disabled="disabled"' : 'readonly="readonly"' ?>>
                            <?php else: ?>
                                <select class="form-control" name="area" id="deliveryArea" <?php !empty($loaded_plan) && $loaded_plan['area'] > 0 ? print'disabled="disabled"' : '' ?>>
                                    <?php if (!empty($branchAdjacentAreas)): ?>
                                        <?php foreach ($branchAdjacentAreas as $area): ?>
                                            <option value="<?php echo $area->title ?>" <?php !empty($loaded_plan) && $loaded_plan['area'] == $area->title ? print'selected=selected' : '' ?>><?php echo $area->title ?></option>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </select>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="one-fifth">
                    <div class="block-inner">
                        <div class="form-group">
                            <label><?php echo $this->lang->line('sector_word_street') ?></label>
                            <input name="sector" value="<?php !empty($thisCustomer) ? print $thisCustomer['sector'] : '' ?>" type="text" class="form-control" placeholder="<?php echo $this->lang->line('sector_word_street') ?>">
                        </div>
                    </div>
                </div>
                <div class="clearfix"></div>
                <div class="one-fifth">
                    <div class="block-inner">
                        <div class="form-group">
                            <label><?php echo $this->lang->line('street_address') ?></label>
                            <input name="street" value="<?php !empty($thisCustomer) ? print $thisCustomer['street'] : '' ?>" type="text" class="form-control" placeholder="<?php echo $this->lang->line('street_address') ?>">
                        </div>
                    </div>
                </div>
                <div class="one-fifth">
                    <div class="block-inner">
                        <div class="form-group">
                            <label><?php echo $this->lang->line('postcode') ?></label>
                            <input name="postcode" value="<?php !empty($thisCustomer) ? print $thisCustomer['postcode'] : '' ?>" type="text" class="form-control" placeholder="<?php echo $this->lang->line('postcode') ?>">
                        </div>
                    </div>
                </div>
                <div class="one-fifth">
                    <div class="block-inner">
                        <div class="form-group">
                            <label><?php echo $this->lang->line('building') ?></label>
                            <input name="building" value="<?php !empty($thisCustomer) ? print $thisCustomer['building'] : '' ?>" type="text" class="form-control" placeholder="<?php echo $this->lang->line('building') ?>">
                        </div>
                    </div>
                </div>
                <div class="one-fifth">
                    <div class="block-inner">
                        <div class="form-group">
                            <label><?php echo $this->lang->line('floor') ?></label>
                            <input name="floor" value="<?php !empty($thisCustomer) ? print $thisCustomer['postcode'] : '' ?>" type="text" class="form-control" placeholder="<?php echo $this->lang->line('floor') ?>">
                        </div>
                    </div>
                </div>
                <div class="one-fifth">
                    <div class="block-inner">
                        <div class="form-group">
                            <label><?php echo $this->lang->line('apartment') ?></label>
                            <input name="apartment" value="<?php !empty($thisCustomer) ? print $thisCustomer['apartment'] : '' ?>" type="text" class="form-control" placeholder="<?php echo $this->lang->line('apartment') ?>">
                        </div>
                    </div>
                </div>
                <div class="one-fifth">
                    <div class="form-group">
                        <div class="block-inner">
                            <div class="form-group">
                                <label><?php echo $this->lang->line('status') ?></label>
                                <select name="status" class="form-control">
                                    <option><?php echo $this->lang->line('select') ?></option>
                                    <option value="3" <?php !empty($thisCustomer) && $thisCustomer['gender'] === 'Male' ? print 'selected="selected"' : '' ?>><?php echo $this->lang->line('active') ?></option>
                                    <option value="2" <?php !empty($thisCustomer) && $thisCustomer['gender'] === 'Female' ? print 'selected="selected"' : '' ?>><?php echo $this->lang->line('inactive') ?></option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="one-fifth">
                    <div class="block-inner">
                        <div class="form-group">
                            <label><?php echo $this->lang->line('photo') ?></label>
                            <input type="file" name="photo" class="form-control">
                        </div>
                    </div>
                </div>
                <div class="one-fifth">
                    <div class="block-inner">
                        <div class="block text-center">
                            <?php if (!empty($thisCustomer) && trim($thisCustomer['photo'])) : ?>
                                <img src="<?php echo EPOS_UPLOAD_PATH . 'customer/' . $thisCustomer['photo'] ?>">
                                <span class="icon icon-trash text-right clearfix" onclick="removeCustomerPhoto('photo', '<?php echo $thisCustomer['photo'] ?>', 'customer', './uploads/customer/', '<?php echo site_url('customer/removeCustomerPhoto/' . $thisCustomer['id']) ?>')">&nbsp;<?php echo $this->lang->line('remove') ?></span>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tab-group config-submit">
                <button type="submit" onclick="saveCustomer('customerForm')"><span class="icon icon-folder"></span>&nbsp;<?php echo $this->lang->line('save') ?></button>
            </div>
            <div class="setting-general-keyboard text-center"></div>
            <div class="clearfix padded-top-more text-right"><span class="icon icon-keyboard btn-keyboard-close" onclick="zamanToogleEposVirtualKeyboard('setting-general-keyboard')">&nbsp;<?php echo $this->lang->line('open_virtual_keyboard') ?></span></div>
        </div>
    </div>
</div>
<?php $this->load->view('settings/partials/footer') ?>
<script>
    function saveCustomer(formId) {
        if (!$('.page-loader').is(":visible")) {
            $('#' + formId).validate({
                submitHandler: function () {
                    var myform = document.getElementById(formId);
                    var formdata = new FormData(myform);
                    if (checkInternetConnection()) {
                        $.ajax({
                            url: $('#' + formId).attr('action'),
                            data: formdata,
                            cache: false,
                            processData: false,
                            contentType: false,
                            type: 'POST',
                            dataType: 'json',
                            beforeSend: function () {
                                $('.page-loader').show();
                            },
                            success: function (response) {
                                $('.page-loader').hide();
                                if (response.status) {
                                    zamanEposNavigator('', '<?php echo site_url('customer') ?>', '');
                                } else {
                                    warning('<?php echo $this->lang->line('error') ?>', response.message, '<?php echo $this->lang->line('ok') ?>');
                                }
                            }
                        });
                    } else {
                        warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
                    }
                },
                errorClass: "has-error",
                highlight: function (e) {
                    $(e).closest('.form-group').addClass('has-error');
                },
                unhighlight: function (e) {
                    $(e).closest('.form-group').removeClass('has-error');
                },
                ignore: ":hidden",
                rules: {
                    name: {required: true, alphanumeric: true},
                    gender: {required: true},
                    email: {
                        required: true,
                        remote: {
                            url: "<?php echo site_url('customer/checkme') ?>",
                            type: "post",
                            data: {
                                value: function () {
                                    return $("#customerEmail").val();
                                },
                                column: 'email',
                                old: function () {
                                    if ($('#oldCustomerEmail').length > 0) {
                                        return $('#oldCustomerEmail').val();
                                    } else {
                                        return 'none';
                                    }
                                },
                                update: function () {
                                    if ($('#updateCustomer').length > 0) {
                                        return 'yes';
                                    } else {
                                        return 'no';
                                    }
                                }
                            }
                        }
                    },
                    phone: {
                        required: true,
                        remote: {
                            url: "<?php echo site_url('customer/checkme') ?>",
                            type: "post",
                            data: {
                                value: function () {
                                    return $("#customerPhone").val();
                                },
                                column: 'phone',
                                old: function () {
                                    if ($('#oldCustomerPhone').length > 0) {
                                        return $('#oldCustomerPhone').val();
                                    } else {
                                        return 'none';
                                    }
                                },
                                update: function () {
                                    if ($('#updateCustomer').length > 0) {
                                        return 'yes';
                                    } else {
                                        return 'no';
                                    }
                                }
                            }
                        }
                    },
                    username: {required: true},
                    password: {required: '<?php empty($thisCustomer) ? print true : print false ?>'},
                    confirmPassword: {equalTo: "#registerFormPassword"},
                    country: {required: true},
                    region: {required: true},
                    city: {required: true},
                    area: {required: true},
                    postcode: {required: true},
                    sector: {required: true},
                    street: {required: true},
                    status: {required: true}
                },
                messages: {
                    name: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('name')) ?>',
                    gender: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('gender')) ?>',
                    email: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('email')) ?>',
                    phone: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('phone')) ?>',
                    username: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('username')) ?>',
                    password: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('password')) ?>',
                    country: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('country')) ?>',
                    region: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('region')) ?>',
                    city: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('city')) ?>',
                    area: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('area')) ?>',
                    postcode: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('postcode')) ?>',
                    sector: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('sector_word_street')) ?>',
                    street: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('street_address')) ?>',
                    status: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('status')) ?>'
                },
                errorPlacement: function (error, element) {
                    errorPlacement(error, element);
                }
            });
        }
    }
    function removeCustomerPhoto(dbkey, dbimage, dbtable, path, url) {
        if (!$('.page-loader').is(":visible")) {
            if (checkInternetConnection()) {
                $.ajax({
                    url: url,
                    data: {
                        dbkey: dbkey,
                        image: dbimage,
                        dbtable: dbtable,
                        path: path
                    },
                    type: 'POST',
                    dataType: 'json',
                    beforeSend: function () {
                        $('.page-loader').show();
                    },
                    success: function (response) {
                        if (response.status) {
                            zamanEposNavigator('', '<?php echo site_url('customer/add/') ?>' + response.id, '');
                        } else {
                            warning('<?php echo $this->lang->line('error') ?>', response.message, '<?php echo $this->lang->line('close') ?>');
                        }
                    }
                });
            } else {
                warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
            }

        }
    }
    function getDeliveryCityAreas(city) {
        if (!$('.page-loader').is(":visible")) {
            $('#deliveryArea').html('');
            if ($.trim(city)) {
                if (checkInternetConnection()) {
                    $.ajax({
                        url: '<?php echo site_url('settings/getCityAreas') ?>',
                        type: 'post',
                        dataType: 'json',
                        data: {
                            city: city
                        },
                        beforeSend: function (xhr) {
                            $('.page-loader').show();
                        },
                        success: function (response) {
                            $('.page-loader').hide();
                            if (response.status) {
                                var items = response.areas;
                                var html = '<option value=""><?php echo $this->lang->line('select') ?></option>';
                                items.forEach(function (item) {
                                    html += '<option value="' + item.title + '">' + item.title + '</option>';
                                });
                                $('#deliveryArea').html(html);
                            }
                        }
                    });
                } else {
                    warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
                }
            } else {
                var html = '<option value="0"><?php echo sprintf($this->lang->line('not_found'), $this->lang->line('area')) ?></option>';
                $('#deliveryArea').html(html);
            }
        }
    }
</script>
