<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class GksoftApi_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }

    public function getUser($username, $password, $userID, $employeeId, $branch, $team) {
        $this->db->select('U.id,U.username,U.display, U.group,U.branch,U.team, U.onapp,U.eposStyle,U.beep,U.beepLabel,E.first_name ,E.last_name');
        $this->db->from('user U');
        $this->db->join('employee E', 'U.employee=E.id', 'left');
        if ($userID && $employeeId) {
            $this->db->where(array('U.id' => $userID, 'U.username' => $username, 'U.password' => md5($password), 'E.id' => $employeeId));
        } else {
            $this->db->where(array('U.username' => $username, 'U.password' => md5($password)));
        }
        $this->db->where(array('U.branch' => $branch, 'U.team' => $team));
        $thisUser = $this->db->get()->result();
        return $thisUser;
    }

    public function getUserList($branch, $team) {
        $this->db->select('U.id,U.username,U.display, U.group,U.branch,U.team, U.onapp,U.eposStyle,U.beep,U.beepLabel,E.id as eId,E.photo,E.gender, E.first_name ,E.last_name');
        $this->db->from('user U');
        $this->db->join('employee E', 'U.employee=E.id', 'left');
        $this->db->where(array('U.branch' => $branch, 'U.team' => $team, 'U.status' => 3, 'U.group>=' => 5));
        return $this->db->get()->result();
    }

    public function getbookingreport($dateFrom, $dateTo, $branch) {
        $this->db->where('date BETWEEN ' . $this->db->escape($dateFrom) . ' AND ' . $this->db->escape($dateTo));
        $this->db->where('branch', $branch);
        $this->db->order_by('date', 'DESC');
        return $this->db->get('booking')->result();
    }

}
