<?php

if (!function_exists('debugPrint')) {

    function debugPrint($object, $title = "", $isMarkup = false) {
        echo '<font color="red">Debug <<< START';
        if (!empty($title)) {
            echo "$title: ";
        }
        if ($isMarkup == false) {
            echo "<pre>";
            print_r($object);
            echo "</pre>";
        } else {
            echo htmlspecialchars($object);
        }
        echo 'END >>></font>';
    }

}

if (!function_exists('getPendingPhone')) {

    function getPendingPhone() {
        $CI = & get_instance();
        $CI->db->where('branch', $CI->session->userdata('branch'));
        $CI->db->where('team', $CI->session->userdata('team'));
        $CI->db->where('received', 'no');
        $CI->db->order_by('date', 'ASC');
        $CI->db->limit(1);
        $data = $CI->db->get('callerphone')->row();
        return json_encode($data);
    }

}
if (!function_exists('getPendingBooking')) {

    function getPendingBooking() {
        $CI = & get_instance();
    }

}
if (!function_exists('getPendingOnlineOrder')) {

    function getPendingOnlineOrder() {
        $CI = & get_instance();
    }

}

if (!function_exists('get_record_list')) {

    function get_record_list($table, $condition = null, $columns = '*', $order = null) {
        $CI = & get_instance();
        $CI->db->select($columns);
        if ($order)
            $CI->db->order_by($order);
        if ($condition)
            $CI->db->where($condition);
        return $CI->db->get($table)->result();
    }

}
if (!function_exists('get_single_record')) {

    function get_single_record($table, $condition = null, $columns = '*', $order = null) {
        $CI = & get_instance();
        $CI->db->select($columns);
        if ($order)
            $CI->db->order_by($order);
        if ($condition)
            $CI->db->where($condition);
        return $CI->db->get($table)->row();
    }

}
if (!function_exists('count_rows')) {

    function count_rows($table, $condition = null) {
        $CI = & get_instance();
        if ($condition) {
            $CI->db->where($condition);
        }
        $CI->db->from($table);
        return $CI->db->count_all_results();
    }

}
if (!function_exists('get_title')) {

    function get_title($table, $condition) {
        $record = get_single_record($table, $condition);
        return !empty($record) ? $record->title : '';
    }

}


if (!function_exists('objectToArray')) {

    function objectToArray($d) {
        if (is_object($d)) {
            $d = get_object_vars($d);
        }
        if (is_array($d)) {
            return array_map(__FUNCTION__, $d);
        } else {
            return $d;
        }
    }

}
if (!function_exists('checkfile')) {

    function checkfile($path = '', $file = '') {
        $filename = $path . $file;
        if (file_exists($filename)) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

}
if (!function_exists('timezone_list')) {

    function timezone_list() {
        $zones_array = array();
        $timestamp = time();
        foreach (timezone_identifiers_list() as $key => $zone) {
            date_default_timezone_set($zone);
            $zones_array[$key]['zone'] = $zone;
            $zones_array[$key]['diff_from_GMT'] = 'UTC/GMT ' . date('P', $timestamp);
        }
        return $zones_array;
    }

}
if (!function_exists('to_currency')) {

    function to_currency($number, $escape = FALSE) {
        $CI = & get_instance();
        if ($CI->config->item('locale_currencysymbol')) {
            $currency_symbol = $CI->config->item('locale_currencyicon') ? $CI->config->item('locale_currencyicon') : $CI->config->item('locale_currencyicon');
            $thousands_separator = $CI->config->item('locale_thouandseparator') ? $CI->config->item('locale_thouandseparator') : '';
            $decimal_point = $CI->config->item('locale_decimalpoint') ? $CI->config->item('locale_decimalpoint') : '.';
            $decimals = $CI->config->item('locale_currencydecimal') ? $CI->config->item('locale_currencydecimal') : 0;
            if ($number >= 0) {
                if (trim($CI->config->item('locale_currencyside')) === 'left') {
                    return $currency_symbol . ' ' . number_format($number, $decimals, $decimal_point, $thousands_separator);
                } else {
                    return number_format($number, $decimals, $decimal_point, $thousands_separator) . ' ' . $currency_symbol;
                }
            } else {
                if (trim($CI->config->item('locale_currencyside')) === 'left') {
                    return $currency_symbol . ' ' . '-' . number_format(abs($number), $decimals, $decimal_point, $thousands_separator);
                } else {
                    return '-' . number_format(abs($number), $decimals, $decimal_point, $thousands_separator) . ' ' . $currency_symbol;
                }
            }
        }
    }

}
if (!function_exists('to_currency_no_money')) {

    function to_currency_no_money($number) {
        if (empty($number)) {
            return $number;
        }
        $CI = & get_instance();
        $decimals = $CI->config->item('locale_currencydecimal') ? $CI->config->item('locale_currencydecimal') : 0;
        return number_format($number, $decimals, '.', '');
    }

}
if (!function_exists('totals_decimals')) {

    function totals_decimals() {
        $CI = & get_instance();
        $decimals = $CI->config->item('locale_currencydecimal') ? $CI->config->item('locale_currencydecimal') : 0;
        return $decimals;
    }

}
if (!function_exists('to_tax_decimals')) {

    function to_tax_decimals($number) {
        if (empty($number)) {
            return $number;
        }

        $CI = & get_instance();
        $decimal_point = $CI->config->item('locale_decimalpoint') ? $CI->config->item('locale_decimalpoint') : '.';
        $decimals = $CI->config->item('locale_taxdecimal') ? $CI->config->item('locale_taxdecimal') : 0;
        return number_format($number, $decimals, $decimal_point, '');
    }

}
if (!function_exists('to_quantity_decimals')) {

    function to_quantity_decimals($number) {
        $CI = & get_instance();
        $decimal_point = $CI->config->item('locale_decimalpoint') ? $CI->config->item('locale_decimalpoint') : '.';
        $decimals = $CI->config->item('locale_quantitydecimal') ? $CI->config->item('locale_quantitydecimal') : 0;
        return number_format($number, $decimals, $decimal_point, '');
    }

}
if (!function_exists('quantity_decimals')) {

    function quantity_decimals() {
        $CI = & get_instance();
        return $CI->config->item('locale_quantitydecimal') ? $CI->config->item('locale_quantitydecimal') : 0;
    }

}
if (!function_exists('currencies')) {

    function currencies() {
        return array(
            'BDT' => 'Bangladeshi Taka',
            'GBP' => 'United Kingdom Pound',
            'USD' => 'United States Dollar',
        );
    }

}
if (!function_exists('getDrivingDistance')) {

    function getDrivingDistance($orgins, $destination) {
        $url = "http://maps.googleapis.com/maps/api/distancematrix/json?origins=" . urlencode($orgins) . "&destinations=" . urlencode($destination) . "&mode=driving&language=en-EN&sensor=false";
        $data = @file_get_contents($url);
        $result = json_decode($data, true);
        if (isset($result ['rows'][0]['elements'][0]['distance'])) {
            $distance = array(
                "meters" => $result["rows"][0]["elements"][0]["distance"]["value"],
                "kilometers" => $result["rows"][0]["elements"][0]["distance"]["value"] / 1000,
                "yards" => $result["rows"][0]["elements"][0]["distance"]["value"] * 1.0936133,
                "miles" => $result["rows"][0]["elements"][0]["distance"]["value"] * 0.000621371
            );
            return ($distance);
        } else {
            $distance = array(
                "meters" => 0,
                "kilometers" => 0,
                "yards" => 0,
                "miles" => 0,
            );
        }
    }

}
if (!function_exists('postcodeFormat')) {

    function postcodeFormat($postcode) {
        $cleanPostcodeParam = preg_replace("/[^A-Za-z0-9]/", '', $postcode);
        $cleanPostcode = strtoupper($cleanPostcodeParam);
        if (strlen($cleanPostcode) == 5) {
            $postcode = substr($cleanPostcode, 0, 2) . " " . substr($cleanPostcode, 2, 3);
        } elseif (strlen($cleanPostcode) == 6) {
            $postcode = substr($cleanPostcode, 0, 3) . " " . substr($cleanPostcode, 3, 3);
        } elseif (strlen($cleanPostcode) == 7) {
            $postcode = substr($cleanPostcode, 0, 4) . " " . substr($cleanPostcode, 4, 3);
        }
        return $postcode;
    }

}
if (!function_exists('getExpenseColumnSum')) {

    function getExpenseColumnSum($id, $field) {
        $CI = & get_instance();
        $CI->db->select_sum($field);
        $CI->db->where('ledger', $id);
        return $CI->db->get('expense')->row();
    }

}
if (!function_exists('isDevice')) {

    function isDevice($device) {
        $ua = $_SERVER["HTTP_USER_AGENT"];
        switch ($device) {
            case 'Android':
                return strpos($ua, 'Android') ? true : false;
            case 'BlackBerry':
                return strpos($ua, 'BlackBerry') ? true : false;
            case 'iPhone':
                return strpos($ua, 'iPhone') ? true : false;
            case 'iPad':
                return strpos($ua, 'iPad') ? true : false;
            case 'Palm':
                return strpos($ua, 'Palm') ? true : false;
            case 'Electron':
                return strpos($ua, 'Electron') ? true : false;
            default :
                return false;
        }
    }

}

if (!function_exists('convertToBanglaNumber')) {

    function convertToBanglaNumber($englishNumber) {
        $englishNumber = (string) $englishNumber;
        $banglaNumber = '';
        $indexLimit = strlen($englishNumber);
        for ($i = 0; $i < $indexLimit; $i++) {
            switch ($englishNumber[$i]) {
                case "0":
                    $banglaNumber .= '&#2534;';
                    break;
                case "1":
                    $banglaNumber .= '&#2535;';
                    break;
                case "2":
                    $banglaNumber .= '&#2536;';
                    break;
                case "3":
                    $banglaNumber .= '&#2537;';
                    break;
                case "4":
                    $banglaNumber .= '&#2538;';
                    break;
                case "5":
                    $banglaNumber .= '&#2539;';
                    break;
                case "6":
                    $banglaNumber .= '&#2540;';
                    break;
                case "7":
                    $banglaNumber .= '&#2541;';
                    break;
                case "8":
                    $banglaNumber .= '&#2542;';
                    break;
                case "9":
                    $banglaNumber .= '&#2543;';
                    break;
                default:
                    $banglaNumber .= $englishNumber[$i];
                    break;
            }
        }
        return $banglaNumber;
    }

}
if (!function_exists('convertToBanglaNumber')) {

    function getBanglaDigit($input) {
        $bn_digits = array('০', '১', '২', '৩', '৪', '৫', '৬', '৭', '৮', '৯');
        $output = str_replace(range(0, 9), $bn_digits, $input);
        return $output;
    }

}