<?php

defined('BASEPATH') OR exit('No direct script access allowed');

/*
  | -------------------------------------------------------------------------
  | URI ROUTING
  | -------------------------------------------------------------------------
  | This file lets you re-map URI requests to specific controller functions.
  |
  | Typically there is a one-to-one relationship between a URL string
  | and its corresponding controller class/method. The segments in a
  | URL normally follow this pattern:
  |
  |	example.com/class/method/id/
  |
  | In some instances, however, you may want to remap this relationship
  | so that a different class/function is called than the one
  | corresponding to the URL.
  |
  | Please see the user guide for complete details:
  |
  |	https://codeigniter.com/user_guide/general/routing.html
  |
  | -------------------------------------------------------------------------
  | RESERVED ROUTES
  | -------------------------------------------------------------------------
  |
  | There are three reserved routes:
  |
  |	$route['default_controller'] = 'welcome';
  |
  | This route indicates which controller class should be loaded if the
  | URI contains no data. In the above example, the "welcome" class
  | would be loaded.
  |
  |	$route['404_override'] = 'errors/page_missing';
  |
  | This route will tell the Router which controller/method to use if those
  | provided in the URL cannot be matched to a valid route.
  |
  |	$route['translate_uri_dashes'] = FALSE;
  |
  | This is not exactly a route, but allows you to automatically route
  | controller and method names that contain dashes. '-' isn't a valid
  | class or method name character, so it requires translation.
  | When you set this option to TRUE, it will replace ALL dashes in the
  | controller and method URI segments.
  |
  | Examples:	my-controller/index	-> my_controller/index
  |		my-controller/my-method	-> my_controller/my_method
 */
$route['default_controller'] = 'takeaway';
$route['404_override'] = 'error';
$route['translate_uri_dashes'] = FALSE;
$route['seo/sitemap\.xml'] = "seo/sitemap";
$route['/'] = 'takeaway';
$route['about'] = 'takeaway/about';
$route['online-order'] = 'takeaway/onlineorder';
$route['onlineorder'] = 'takeaway/onlineorder';
$route['checkout'] = 'takeaway/checkout';
$route['gallery'] = 'takeaway/gallery';
$route['contact'] = 'takeaway/contact';
$route['pre-order'] = 'takeaway/preorder';
$route['reservation'] = 'takeaway/reservation';
$route['customer-login'] = 'takeaway/customer_login';
$route['customer-signup'] = 'takeaway/customer_signup';
$route['account-recovery'] = 'takeaway/account_recovery';
$route['change-account-password/(:any)'] = 'takeaway/change_account_password/$1';
$route['review'] = 'takeaway/review';
$route['reservation-confirmation/(:num)/(:num)/(:any)'] = 'takeaway/reservation_confirmation/$1/$1/$1';
$route['my-account'] = 'myaccount';
$route['my-account/profile'] = 'myaccount/profile';
$route['my-account/password'] = 'myaccount/password';
$route['my-account/address'] = 'myaccount/address';
$route['my-account/address/(:num)'] = 'myaccount/address/$1';
$route['my-account/checkout'] = 'myaccount/checkout';
$route['my-account/checkAddressType'] = 'myaccount/checkAddressType';
$route['my-account/orders'] = 'myaccount/orders';
$route['my-account/payment-online'] = 'myaccount/payment_online';
$route['my-account/order-confirmation/(:num)'] = 'myaccount/order_confirmation/$1';
$route['my-account/orderdetail/(:num)'] = 'myaccount/orderdetail/$1';
$route['my-account/signout'] = 'myaccount/signout';
$route['terms-and-condition'] = "takeaway/termsandcondition";
$route['delivery-information'] = "takeaway/deliveryInformation";

